/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.minecraft.renderer;

import com.gfactory.core.mqo.MQO;
import com.gfactory.core.mqo.MQOObject;
import com.gfactory.gts.common.controller.GTSCycle;
import com.gfactory.gts.common.controller.GTSPhase;
import com.gfactory.gts.minecraft.renderer.GTSTileEntityRenderer;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntityTrafficController;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntityTrafficLight;
import com.gfactory.gts.pack.GTSPack;
import com.gfactory.gts.pack.config.GTSConfig;
import com.gfactory.gts.pack.config.GTSTrafficLightConfig;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GTSTileEntityTrafficLightRenderer
extends GTSTileEntityRenderer<GTSTileEntityTrafficLight, GTSTrafficLightConfig> {
    @Override
    public void renderModel(GTSTileEntityTrafficLight te, GTSPack pack, GTSTrafficLightConfig config, Tessellator t, MQO model, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (te == null || pack == null || config == null) {
            return;
        }
        ResourceLocation textureBase = te.getPack().getOrCreateBindTexture(((GTSConfig.GTSTexture)config.getTextures()).getBase());
        ResourceLocation textureLight = te.getPack().getOrCreateBindTexture(((GTSTrafficLightConfig.GTSTrafficLightTexture)config.getTextures()).getLight());
        ResourceLocation textureNoLight = te.getPack().getOrCreateBindTexture(((GTSTrafficLightConfig.GTSTrafficLightTexture)config.getTextures()).getNoLight());
        if (textureBase == null || textureLight == null || textureNoLight == null) {
            return;
        }
        this.func_147499_a(textureBase);
        for (MQOObject o : model.getObjects()) {
            if (!config.getBody().contains(o.getName())) continue;
            o.draw();
        }
        if (te.getAttachedTrafficController() == null) {
            return;
        }
        TileEntity ttt = te.func_145831_w().func_175625_s(te.getAttachedTrafficController());
        if (!(ttt instanceof GTSTileEntityTrafficController)) {
            return;
        }
        GTSTileEntityTrafficController tttt = (GTSTileEntityTrafficController)ttt;
        GTSCycle cycle = tttt.getNowCycle();
        if (cycle == null) {
            return;
        }
        GTSPhase phase = cycle.getNowPhase();
        if (phase == null) {
            return;
        }
        GTSTrafficLightConfig.GTSTrafficLightPattern p = tttt.getNowCycle().getNowPhase().getChannels().get(te.getChannel());
        if (p == null) {
            return;
        }
        boolean light = p.getTick() == 0 || p.getTick() != 0 && phase.getTicks() % (long)p.getTick() < (long)(p.getTick() / 2);
        this.func_147499_a(textureNoLight);
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        if (textureLight.equals((Object)textureNoLight)) {
            GL11.glColor3f((float)0.5f, (float)0.5f, (float)0.5f);
        }
        GL11.glDisable((int)2896);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)60.0f, (float)60.0f);
        for (MQOObject o : model.getObjects()) {
            if (p.getObjects().contains(o.getName()) && light || !config.getLight().contains(o.getName())) continue;
            o.draw();
        }
        this.func_147499_a(textureLight);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        for (MQOObject o : model.getObjects()) {
            if (!config.getLight().contains(o.getName()) || !p.getObjects().contains(o.getName()) || !light) continue;
            o.draw();
        }
        RenderHelper.func_74519_b();
        GlStateManager.func_179145_e();
        GL11.glEnable((int)2896);
    }
}

