/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.minecraft;

import com.gfactory.gts.common.GTSClassScanner;
import com.gfactory.gts.common.GTSPackLoader;
import com.gfactory.gts.common.GTSSignTextureManager;
import com.gfactory.gts.common.controller.GTSCycle;
import com.gfactory.gts.common.controller.GTSPhase;
import com.gfactory.gts.minecraft.proxy.GTSProxy;
import com.gfactory.gts.pack.config.GTSConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.RuntimeTypeAdapterFactory;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="gts", name="GTS - Ginren Traffic System", version="2.0-alpha2", acceptedMinecraftVersions="[1.12.2]")
public class GTS {
    public static final String MODID = "gts";
    public static final String NAME = "GTS - Ginren Traffic System";
    public static final String VERSION = "2.0-alpha2";
    public static final Logger LOGGER = LogManager.getLogger((String)"GTS");
    public static final GTSPackLoader LOADER = new GTSPackLoader();
    @SidedProxy(clientSide="com.gfactory.gts.minecraft.proxy.GTSClientProxy", serverSide="com.gfactory.gts.minecraft.proxy.GTSProxy")
    public static GTSProxy proxy;
    public static CreativeTabs TAB;
    public static GTSSignTextureManager SIGN_MANAGER;
    public static Gson GSON;
    public static final SimpleNetworkWrapper NETWORK;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws InterruptedException {
        RuntimeTypeAdapterFactory<GTSCycle> typeFactory = RuntimeTypeAdapterFactory.of(GTSCycle.class, "type");
        for (Class<? extends GTSCycle> clazz : GTSClassScanner.findCycleClass()) {
            LOGGER.debug(I18n.func_135052_a((String)"gts.message.find.class", (Object[])new Object[]{clazz.getName()}));
            typeFactory.registerSubtype(clazz);
        }
        RuntimeTypeAdapterFactory<GTSPhase> typeFactory2 = RuntimeTypeAdapterFactory.of(GTSPhase.class, "type");
        for (Class<? extends GTSPhase> clazz : GTSClassScanner.findPhaseClass()) {
            LOGGER.debug(I18n.func_135052_a((String)"gts.message.find.class", (Object[])new Object[]{clazz.getName()}));
            typeFactory2.registerSubtype(clazz);
        }
        RuntimeTypeAdapterFactory<GTSConfig> runtimeTypeAdapterFactory = RuntimeTypeAdapterFactory.of(GTSConfig.class, "type");
        for (Class<? extends GTSConfig> clazz : GTSClassScanner.findConfigClass()) {
            LOGGER.debug(I18n.func_135052_a((String)"gts.message.find.class", (Object[])new Object[]{clazz.getName()}));
            runtimeTypeAdapterFactory.registerSubtype(clazz, clazz.getSimpleName().toLowerCase().replace(MODID, "").replace("config", "").replace("traffic", ""));
        }
        GSON = new GsonBuilder().registerTypeAdapterFactory(typeFactory).registerTypeAdapterFactory(typeFactory2).registerTypeAdapterFactory(runtimeTypeAdapterFactory).setPrettyPrinting().create();
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    static {
        NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
    }
}

