/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.common.controller;

import com.gfactory.gts.common.controller.GTSPhase;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntityTrafficController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import net.minecraft.world.World;
import org.apache.commons.lang3.RandomStringUtils;

public abstract class GTSCycle {
    protected String id;
    protected final ArrayList<GTSPhase> phases = new ArrayList();
    protected int nowPhase = 0;
    protected boolean end = false;
    protected long tick;
    protected ArrayList<String> metaInfo = new ArrayList();

    public GTSCycle() {
        this(new SimpleDateFormat("yyyyMMdd").format(Calendar.getInstance().getTime()) + RandomStringUtils.randomAlphanumeric((int)24));
    }

    public GTSCycle(String id) {
        this.id = id;
    }

    public abstract boolean canStart(GTSTileEntityTrafficController var1, boolean var2, World var3);

    public abstract int getNextPhase(GTSTileEntityTrafficController var1, boolean var2, World var3);

    public abstract int getInitialPhase(GTSTileEntityTrafficController var1, boolean var2, World var3);

    public final void nextPhase(GTSTileEntityTrafficController te, boolean detected, World world) {
        int next = Math.min(this.getNextPhase(te, detected, world), this.phases.size() - 1);
        if (next >= 0) {
            this.phases.get(this.nowPhase).resetTick();
            this.nowPhase = next;
            this.phases.get(this.nowPhase).resetTick();
        } else {
            this.end = true;
        }
    }

    public final void resetPhase(GTSTileEntityTrafficController te, boolean detected, World world) {
        int initial = Math.min(this.getInitialPhase(te, detected, world), this.phases.size() - 1);
        if (initial < 0) {
            initial = 0;
        }
        this.end = false;
        this.nowPhase = initial;
        this.phases.get(this.nowPhase).resetTick();
        this.tick = 0L;
    }

    public boolean tick(GTSTileEntityTrafficController te, boolean detected, World world) {
        if (this.phases.isEmpty()) {
            return true;
        }
        GTSPhase phase = this.getNowPhase();
        if (phase == null) {
            this.resetPhase(te, detected, world);
            return true;
        }
        if (phase.shouldContinue(te, this.tick, detected, world)) {
            phase.nextTick();
            ++this.tick;
            return false;
        }
        this.nextPhase(te, detected, world);
        if (this.end) {
            this.resetPhase(te, detected, world);
            return true;
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public int getNowPhaseNumber() {
        return this.nowPhase;
    }

    public GTSPhase getNowPhase() {
        try {
            if (this.nowPhase > this.phases.size()) {
                this.nowPhase = 0;
            }
            return this.phases.get(this.nowPhase);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList<GTSPhase> getPhases() {
        return this.phases;
    }

    public boolean isEnd() {
        return this.end;
    }

    public void finish() {
        this.end = true;
    }

    public String toString() {
        return "GTSCycle{end=" + this.end + ", id='" + this.id + '\'' + ", phases=" + this.phases + ", nowPhase=" + this.nowPhase + ", tick=" + this.tick + '}';
    }

    public ArrayList<String> getMetaInfo() {
        return this.metaInfo;
    }

    public void setMetaInfo(ArrayList<String> metaInfo) {
        this.metaInfo = metaInfo;
    }

    public ArrayList<String> getMetaInfoTitles() {
        return new ArrayList<String>();
    }
}

