/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.minecraft.tileentity;

import com.gfactory.core.helper.GNBTHelper;
import com.gfactory.gts.minecraft.GTS;
import com.gfactory.gts.minecraft.network.packet.GTSPacketTileEntity;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntity;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntityTrafficArm;
import com.gfactory.gts.minecraft.tileentity.IGTSAttachable;
import com.gfactory.gts.pack.GTSPack;
import com.gfactory.gts.pack.config.GTSTrafficPoleConfig;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;

public class GTSTileEntityTrafficPole
extends GTSTileEntity<GTSTrafficPoleConfig>
implements IGTSAttachable<GTSTileEntityTrafficArm> {
    private ArrayList<GTSTileEntityTrafficArm> jointArms = new ArrayList();
    private boolean upJoint = false;
    private boolean bottomJoint = false;

    public GTSTileEntityTrafficPole() {
        this.setDummy();
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public void setDummy() {
        GTSPack p = GTS.LOADER.getDummy();
        if (p == null) {
            throw new RuntimeException("Dummy Model cannot be loaded.");
        }
        this.pack = p;
        GTSTrafficPoleConfig config = new GTSTrafficPoleConfig();
        config.setDummy();
        this.setConfig(config);
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB box = new AxisAlignedBB(this.field_174879_c);
        for (GTSTileEntityTrafficArm arm : this.getJointArms()) {
            box = box.func_111270_a(new AxisAlignedBB(arm.func_174877_v()));
        }
        return box;
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        this.upJoint = GNBTHelper.getBooleanWithValue(compound, "gts_upjoint", false);
        this.bottomJoint = GNBTHelper.getBooleanWithValue(compound, "gts_bottomjoint", false);
        ArrayList<GTSTileEntityTrafficArm> arms = new ArrayList<GTSTileEntityTrafficArm>();
        for (int i = 0; i < compound.func_150295_c("gts_attached_traffic_arm", 10).func_74745_c(); ++i) {
            NBTTagCompound tag = compound.func_150295_c("gts_attached_traffic_arm", 10).func_150305_b(i);
            GTSTileEntityTrafficArm arm = new GTSTileEntityTrafficArm(null);
            arm.func_145839_a(tag);
            arms.add(arm);
        }
        this.jointArms = arms;
    }

    @Override
    public NBTTagCompound writeDataToNBT(NBTTagCompound compound) {
        compound.func_74757_a("gts_upjoint", this.upJoint);
        compound.func_74757_a("gts_bottomjoint", this.bottomJoint);
        NBTTagList list = new NBTTagList();
        for (GTSTileEntityTrafficArm arm : this.jointArms) {
            NBTTagCompound c = new NBTTagCompound();
            c = arm.func_189515_b(c);
            list.func_74742_a((NBTBase)c);
        }
        compound.func_74782_a("gts_attached_traffic_arm", (NBTBase)list);
        return compound;
    }

    public ArrayList<GTSTileEntityTrafficArm> getJointArms() {
        return this.jointArms;
    }

    public void setJointArms(ArrayList<GTSTileEntityTrafficArm> jointArms) {
        this.jointArms = jointArms;
    }

    public boolean isBottomJoint() {
        return this.bottomJoint;
    }

    public void setBottomJoint(boolean bottomJoint) {
        this.bottomJoint = bottomJoint;
    }

    public boolean isUpJoint() {
        return this.upJoint;
    }

    public void setUpJoint(boolean upJoint) {
        this.upJoint = upJoint;
    }

    @Override
    public void attach(GTSTileEntityTrafficArm te) {
        if (this.jointArms.contains((Object)te)) {
            return;
        }
        this.jointArms.add(te);
        this.func_70296_d();
        if (this.field_145850_b.field_72995_K) {
            GTS.NETWORK.sendToServer(new GTSPacketTileEntity<GTSTileEntityTrafficPole>(this.func_189515_b(new NBTTagCompound()), this.field_174879_c, GTSTileEntityTrafficPole.class));
        } else {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 15);
        }
    }

    @Override
    public void deattach(GTSTileEntityTrafficArm te) {
        this.jointArms.remove((Object)te);
        this.func_70296_d();
        if (this.field_145850_b.field_72995_K) {
            GTS.NETWORK.sendToServer(new GTSPacketTileEntity<GTSTileEntityTrafficPole>(this.func_189515_b(new NBTTagCompound()), this.field_174879_c, GTSTileEntityTrafficPole.class));
        } else {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 15);
        }
    }

    @Override
    public void reset() {
        this.jointArms.clear();
        this.func_70296_d();
        if (this.field_145850_b.field_72995_K) {
            GTS.NETWORK.sendToServer(new GTSPacketTileEntity<GTSTileEntityTrafficPole>(this.func_189515_b(new NBTTagCompound()), this.field_174879_c, GTSTileEntityTrafficPole.class));
        } else {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 15);
        }
    }
}

