/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.pack;

import com.gfactory.gts.pack.GTSPack;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;

public class GTSMemoryResourcePack
implements IResourcePack {
    private final GTSPack pack;
    private String soundJson;

    public GTSMemoryResourcePack(GTSPack pack) {
        this.pack = pack;
        this.createSoundJson();
    }

    private void createSoundJson() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (String path : this.pack.getSounds().keySet()) {
            sb.append("\"").append(this.func_130077_b().toLowerCase()).append(":").append(path.replace(".ogg", "")).append("\": {");
            sb.append("\"category\": \"block\",");
            sb.append("\"sounds\": [{");
            sb.append("\"name\": \"").append(this.func_130077_b().toLowerCase()).append(":").append(path.replace(".ogg", "")).append("\",");
            sb.append("\"weight\": 100,");
            sb.append("\"preload\": true");
            sb.append("}]");
            sb.append("},");
        }
        if (!this.pack.getSounds().isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("}");
        this.soundJson = sb.toString();
    }

    public InputStream func_110590_a(ResourceLocation location) throws IOException {
        if (this.pack.getSounds().containsKey(location.func_110623_a())) {
            return new ByteArrayInputStream(this.pack.getSounds().get(location.func_110623_a()));
        }
        if (location.func_110623_a().equals("sounds/sounds.json")) {
            return new ByteArrayInputStream(this.soundJson.getBytes(StandardCharsets.UTF_8));
        }
        throw new FileNotFoundException(location.toString());
    }

    public boolean func_110589_b(ResourceLocation location) {
        if (!location.func_110624_b().equals(this.func_130077_b().toLowerCase())) {
            return false;
        }
        if (location.func_110623_a().equals("sounds/sounds.json")) {
            return true;
        }
        return this.pack.getSounds().containsKey(location.func_110623_a());
    }

    public Set<String> func_110587_b() {
        return Collections.singleton("gts_" + this.pack.getName().toLowerCase());
    }

    @Nullable
    public <T extends IMetadataSection> T func_135058_a(MetadataSerializer metadataSerializer, String metadataSectionName) throws IOException {
        return null;
    }

    public BufferedImage func_110586_a() throws IOException {
        return null;
    }

    public String func_130077_b() {
        return "gts_" + this.pack.getName();
    }
}

