/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.common.controller;

import com.gfactory.gts.minecraft.tileentity.GTSTileEntityTrafficController;
import com.gfactory.gts.pack.config.GTSTrafficLightConfig;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedHashMap;
import net.minecraft.world.World;
import org.apache.commons.lang3.RandomStringUtils;

public class GTSPhase {
    protected String id;
    protected final LinkedHashMap<String, GTSTrafficLightConfig.GTSTrafficLightPattern> channels = new LinkedHashMap();
    protected long ticks;

    public GTSPhase() {
        this.id = new SimpleDateFormat("yyyyMMdd").format(Calendar.getInstance().getTime()) + RandomStringUtils.randomAlphanumeric((int)24);
    }

    public GTSPhase(String id) {
        this.id = id;
    }

    public GTSPhase addChannel(String id, GTSTrafficLightConfig.GTSTrafficLightPattern pattern) {
        this.channels.put(id, pattern);
        return this;
    }

    public GTSPhase addChannelTry(String id, GTSTrafficLightConfig.GTSTrafficLightPattern pattern) throws IllegalArgumentException {
        if (this.channels.containsKey(id)) {
            throw new IllegalArgumentException("Key" + id + " exist!");
        }
        return this.addChannel(id, pattern);
    }

    public long getTicks() {
        return this.ticks;
    }

    public GTSPhase resetTick() {
        this.ticks = 0L;
        return this;
    }

    public GTSPhase nextTick() {
        ++this.ticks;
        return this;
    }

    public GTSPhase setTicks(long ticks) {
        this.ticks = ticks;
        return this;
    }

    public LinkedHashMap<String, GTSTrafficLightConfig.GTSTrafficLightPattern> getChannels() {
        return this.channels;
    }

    public boolean shouldContinue(GTSTileEntityTrafficController te, long totalticks, boolean detected, World world) {
        return false;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String toString() {
        return "GTSPhase{channels=" + this.channels + ", id='" + this.id + '\'' + ", ticks=" + this.ticks + '}';
    }
}

