/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.tool.component;

import com.gfactory.gts.tool.GTSPackMaker;
import com.gfactory.gts.tool.GTSPackMakerConstants;
import com.gfactory.gts.tool.component.tab.GTSTabTextureView;
import com.gfactory.gts.tool.helper.I18n;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class GTSSideTreeView
extends JScrollPane
implements MouseListener {
    private JTree projectTree;
    private DefaultTreeModel treeModel;

    public GTSSideTreeView() {
        this.init();
    }

    public void init() {
        this.setPreferredSize(new Dimension(200, 0));
        this.initTreeModel();
        this.setViewportView(this.projectTree);
    }

    public void createTreeModel(File file) throws IllegalArgumentException {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(file);
        this.treeModel = new DefaultTreeModel(rootNode);
        this.searchDirectory(rootNode, file);
        this.treeModel.reload();
        this.projectTree.setModel(this.treeModel);
        this.projectTree.setVisible(true);
    }

    private void initTreeModel() {
        this.treeModel = null;
        this.projectTree = new JTree();
        this.projectTree.setCellRenderer(new GTSFileTreeRender());
        this.projectTree.setRowHeight(20);
        this.projectTree.addMouseListener(this);
        this.projectTree.setVisible(false);
    }

    private void searchDirectory(DefaultMutableTreeNode node, File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                DefaultMutableTreeNode child = new DefaultMutableTreeNode(f);
                node.add(child);
                if (!f.isDirectory()) continue;
                this.searchDirectory(child, f);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() < 2) {
            return;
        }
        TreePath path = this.projectTree.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object f = node.getUserObject();
        if (!(f instanceof File)) {
            return;
        }
        File file = (File)f;
        if (file.isDirectory()) {
            return;
        }
        if (!file.getName().endsWith(".mqo")) {
            if (file.getName().endsWith(".png") || file.getName().endsWith(".jpg")) {
                GTSTabTextureView panel = new GTSTabTextureView(file);
                GTSPackMaker.mainView.addTab(file.getName(), GTSPackMakerConstants.ICON_TEXTURE, panel, "");
            } else if (!file.getName().endsWith(".json")) {
                JOptionPane.showMessageDialog(GTSPackMaker.window, I18n.format("message.unsupportFile", file.getName()), I18n.format("message.title.unsupportFile", new String[0]), 0);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private static class GTSFileTreeRender
    extends DefaultTreeCellRenderer {
        private GTSFileTreeRender() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object userObject = node.getUserObject();
            if (userObject instanceof File) {
                File file = (File)userObject;
                this.setText(file.getName());
                if (file.isDirectory()) {
                    this.setIcon(GTSPackMakerConstants.ICON_DIRECTORY);
                } else if (file.getName().endsWith(".mqo")) {
                    this.setIcon(GTSPackMakerConstants.ICON_MODEL);
                } else if (file.getName().endsWith(".png") || file.getName().endsWith(".jpg")) {
                    this.setIcon(GTSPackMakerConstants.ICON_TEXTURE);
                } else if (file.getName().endsWith(".json")) {
                    this.setIcon(GTSPackMakerConstants.ICON_FILE);
                } else if (file.getName().endsWith(".ogg")) {
                    this.setIcon(GTSPackMakerConstants.ICON_SOUND);
                } else {
                    this.setIcon(GTSPackMakerConstants.ICON_CLOSE);
                }
            }
            return c;
        }
    }
}

