/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.tool.project;

import com.gfactory.gts.tool.GTSPackMaker;
import com.gfactory.gts.tool.helper.I18n;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;

public class GTSPackProject {
    private File projectDirectory;
    private ArrayList<File> projectFiles = new ArrayList();
    private boolean scanning = false;

    public GTSPackProject(File directory) {
        this.projectDirectory = directory;
        this.scanFiles();
    }

    public File getProjectDirectory() {
        return this.projectDirectory;
    }

    public void setProjectDirectory(File directory) {
        this.projectDirectory = directory;
        this.scanFiles();
    }

    public ArrayList<File> getProjectFiles() {
        return this.projectFiles;
    }

    public boolean isProjectExists() {
        return this.projectDirectory.exists();
    }

    private void scanFiles() {
        ScanTask task = new ScanTask(this);
        if (!this.scanning) {
            task.execute();
        }
    }

    private static class ScanTask
    extends SwingWorker<Void, Integer> {
        private GTSPackProject project;

        public ScanTask(GTSPackProject project) {
            this.project = project;
            this.project.projectFiles.clear();
            this.addPropertyChangeListener(e -> {
                if ("progress".equals(e.getPropertyName())) {
                    GTSPackMaker.progressBar.setValue((Integer)e.getNewValue());
                }
            });
        }

        @Override
        protected Void doInBackground() throws Exception {
            this.project.scanning = true;
            this.scanFiles(this.project.projectDirectory);
            return null;
        }

        private void scanFiles(File file) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files == null) {
                    return;
                }
                this.publish(files.length);
                for (File f : files) {
                    this.scanFiles(f);
                }
            } else {
                this.publish(0);
                this.project.projectFiles.add(file);
            }
        }

        @Override
        protected void process(List<Integer> chunks) {
            GTSPackMaker.progressBar.setValue(this.project.projectFiles.size());
            int max = 0;
            for (Integer chunk : chunks) {
                max += chunk.intValue();
            }
        }

        @Override
        protected void done() {
            super.done();
            this.project.scanning = false;
            GTSPackMaker.progressBar.setValue(100);
            GTSPackMaker.statusBar.setText(I18n.format("status.openProject", this.project.projectDirectory.getAbsolutePath()));
        }
    }
}

