/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.minecraft.block;

import com.gfactory.gts.common.capability.GTSCapabilities;
import com.gfactory.gts.common.capability.IGTSSelection;
import com.gfactory.gts.minecraft.block.GTSBlock;
import com.gfactory.gts.minecraft.gui.GTSGuiTrafficButton;
import com.gfactory.gts.minecraft.item.GTSItems;
import com.gfactory.gts.minecraft.sound.GTSSoundTrafficButtonDetected;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntityTrafficButton;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntityTrafficController;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class GTSBlockTrafficButton
extends GTSBlock<GTSTileEntityTrafficButton> {
    public GTSBlockTrafficButton() {
        super(GTSTileEntityTrafficButton.class);
        this.setRegistryName("traffic_button");
        this.func_149663_c("traffic_button");
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            return false;
        }
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        if (!super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ)) {
            return false;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof GTSTileEntityTrafficButton)) {
            return false;
        }
        GTSTileEntityTrafficButton self = (GTSTileEntityTrafficButton)te;
        ItemStack item = playerIn.func_184586_b(hand);
        if (item.func_77969_a(new ItemStack(GTSItems.ATTACHMENT))) {
            IGTSSelection selection = (IGTSSelection)playerIn.getCapability(GTSCapabilities.SELECTION_CAP, null);
            if (selection == null) {
                return false;
            }
            BlockPos selectedPos = selection.getSelectedTileEntity();
            if (pos.equals((Object)selectedPos)) {
                selection.clearSelection();
                playerIn.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"gts.message.chat.deselected", (Object[])new Object[]{pos})));
            } else {
                selection.setSelectedTileEntity(pos);
                playerIn.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"gts.message.chat.selected", (Object[])new Object[]{pos})));
            }
        } else if (playerIn.func_70093_af()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GTSGuiTrafficButton(self));
        } else {
            if (self.getAttachedTrafficController() == null) {
                playerIn.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"gts.message.chat.no.attached", (Object[])new Object[0])));
                return false;
            }
            if (self.isDetected()) {
                return false;
            }
            self.setDetected(true);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new GTSSoundTrafficButtonDetected(self));
        }
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te2;
        GTSTileEntityTrafficButton self;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof GTSTileEntityTrafficButton && (self = (GTSTileEntityTrafficButton)te).getAttachedTrafficController() != null && (te2 = worldIn.func_175625_s(self.getAttachedTrafficController())) instanceof GTSTileEntityTrafficController) {
            GTSTileEntityTrafficController controller = (GTSTileEntityTrafficController)te2;
            controller.deattach(self);
        }
        super.func_180663_b(worldIn, pos, state);
    }
}

