/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.common.controller;

import com.gfactory.gts.common.controller.GTSCycle;
import com.gfactory.gts.minecraft.GTS;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntityTrafficController;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.World;

public class GTSScriptCycle
extends GTSCycle {
    private transient ScriptEngine engine;
    private File scriptFile;

    @Override
    public ArrayList<String> getMetaInfoTitles() {
        ArrayList<String> result = super.getMetaInfoTitles();
        result.add(I18n.func_135052_a((String)"gts.cycle.script.arg1", (Object[])new Object[0]));
        return result;
    }

    public GTSScriptCycle() {
        ScriptEngineManager manager = new ScriptEngineManager();
        this.engine = manager.getEngineByName("js");
        if (this.engine == null) {
            throw new RuntimeException(I18n.func_135052_a((String)"gts.exception.script_engine", (Object[])new Object[0]));
        }
    }

    public GTSScriptCycle(File scriptFile) {
        this();
        this.scriptFile = scriptFile;
    }

    @Override
    public boolean canStart(GTSTileEntityTrafficController te, boolean detected, World world) {
        if (this.scriptFile == null) {
            return false;
        }
        if (this.engine == null) {
            return false;
        }
        Map<String, Object> map = this.getBindJavaObjects();
        map.put("te", te);
        map.put("detected", detected);
        map.put("world", world);
        SimpleBindings bind = new SimpleBindings(map);
        try {
            Object flag = this.engine.eval("canStart(te, detected, world);", (Bindings)bind);
            if (flag instanceof Boolean) {
                return (Boolean)flag;
            }
            return false;
        }
        catch (ScriptException e) {
            GTS.LOGGER.error(I18n.func_135052_a((String)"gts.exception.script_engine.eval", (Object[])new Object[]{e.getMessage()}));
            return false;
        }
    }

    @Override
    public int getNextPhase(GTSTileEntityTrafficController te, boolean detected, World world) {
        if (this.scriptFile == null) {
            return -1;
        }
        if (this.engine == null) {
            return -1;
        }
        Map<String, Object> map = this.getBindJavaObjects();
        map.put("te", te);
        map.put("detected", detected);
        map.put("world", world);
        SimpleBindings bind = new SimpleBindings(map);
        try {
            Object flag = this.engine.eval("canStart(te, detected, world);", (Bindings)bind);
            if (flag instanceof Integer) {
                return (Integer)flag;
            }
            return -1;
        }
        catch (ScriptException e) {
            GTS.LOGGER.error(I18n.func_135052_a((String)"gts.exception.script_engine.eval", (Object[])new Object[]{e.getMessage()}));
            return -1;
        }
    }

    @Override
    public int getInitialPhase(GTSTileEntityTrafficController te, boolean detected, World world) {
        if (this.scriptFile == null) {
            return 0;
        }
        if (this.engine == null) {
            return 0;
        }
        Map<String, Object> map = this.getBindJavaObjects();
        map.put("te", te);
        map.put("detected", detected);
        map.put("world", world);
        SimpleBindings bind = new SimpleBindings(map);
        try {
            Object flag = this.engine.eval("canStart(te, detected, world);", (Bindings)bind);
            if (flag instanceof Integer) {
                return (Integer)flag;
            }
            return 0;
        }
        catch (ScriptException e) {
            GTS.LOGGER.error(I18n.func_135052_a((String)"gts.exception.script_engine.eval", (Object[])new Object[]{e.getMessage()}));
            return 0;
        }
    }

    private boolean parse() {
        if (this.engine == null || this.scriptFile == null) {
            return false;
        }
        try (FileReader fr = new FileReader(this.scriptFile);){
            this.engine.eval(fr);
        }
        catch (FileNotFoundException e) {
            GTS.LOGGER.error(I18n.func_135052_a((String)"gts.exception.script_engine.notfound", (Object[])new Object[]{this.scriptFile.getName()}));
            return false;
        }
        catch (ScriptException e) {
            GTS.LOGGER.error(I18n.func_135052_a((String)"gts.exception.script_engine.eval", (Object[])new Object[]{e.getMessage()}));
            return false;
        }
        catch (IOException e) {
            GTS.LOGGER.error(I18n.func_135052_a((String)"gts.exception.script_engine.io", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected Map<String, Object> getBindJavaObjects() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("binding", new GTSBinding());
        return map;
    }

    public File getScriptFile() {
        return this.scriptFile;
    }

    public void setScriptFile(File scriptFile) {
        this.scriptFile = scriptFile;
        this.parse();
    }

    public static class GTSBinding {
        public void log(Object obj) {
            GTS.LOGGER.debug("Script Engine said: {}", (Object)obj.toString());
        }
    }
}

