/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.pack;

import com.gfactory.core.mqo.MQO;
import com.gfactory.core.mqo.MQOException;
import com.gfactory.core.mqo.MQOLoader;
import com.gfactory.gts.minecraft.GTS;
import com.gfactory.gts.pack.config.GTSConfig;
import com.gfactory.gts.pack.config.GTSTrafficArmConfig;
import com.gfactory.gts.pack.config.GTSTrafficButtonConfig;
import com.gfactory.gts.pack.config.GTSTrafficControllerConfig;
import com.gfactory.gts.pack.config.GTSTrafficLightConfig;
import com.gfactory.gts.pack.config.GTSTrafficPoleConfig;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.ProgressManager;

public class GTSPack {
    private final HashMap<String, byte[]> sounds = new HashMap();
    private final HashMap<String, SoundEvent> soundEvents = new HashMap();
    private final HashMap<String, BufferedImage> textures = new HashMap();
    private final HashMap<String, ResourceLocation> bindTextures = new HashMap();
    private final HashMap<String, MQO> models = new HashMap();
    private final HashMap<Double, HashMap<String, MQO>> resizedModels = new HashMap();
    private final HashMap<String, GTSConfig<GTSConfig.GTSTexture>> configs = new HashMap();
    private String name = "dummy";
    private String author = "dummy";
    private final HashMap<String, String> metas = new HashMap();
    private File file;
    private static GTSPack dummyPack;
    public static final String DUMMY = "dummy";
    public static final String DUMMY_TRAFFIC_LIGHT = "traffic_light";
    public static final String DUMMY_TRAFFIC_CONTROLLER = "traffic_controller";
    public static final String DUMMY_TRAFFIC_POLE = "traffic_pole";
    public static final String DUMMY_TRAFFIC_ARM = "traffic_arm";
    public static final String DUMMY_TRAFFIC_BUTTON = "traffic_button";

    private GTSPack() {
    }

    public boolean empty() {
        return this.sounds.isEmpty() && this.textures.isEmpty();
    }

    public boolean dummy() {
        return this.file == null;
    }

    public static GTSPack load(ZipInputStream zis, File file) throws IllegalArgumentException, IOException {
        if (zis == null || file == null) {
            throw new IllegalArgumentException(I18n.func_135052_a((String)"gts.exception.argument", (Object[])new Object[0]));
        }
        Pattern p = Pattern.compile("^(.+?)=(.*)$");
        GTSPack pack = new GTSPack();
        pack.file = file;
        ZipFile zfile = new ZipFile(file);
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Pack file loading", (int)zfile.size());
        zfile = null;
        ZipEntry entry = null;
        while ((entry = zis.getNextEntry()) != null) {
            ByteArrayInputStream bais;
            Throwable throwable;
            GTS.LOGGER.debug(entry.getName());
            bar.step(entry.getName());
            byte[] data = GTSPack.readData(entry, zis);
            if (entry.getName().equals("gts.txt")) {
                Scanner s = new Scanner(new String(data, StandardCharsets.UTF_8));
                throwable = null;
                try {
                    while (s.hasNextLine()) {
                        String line = s.nextLine();
                        Matcher m = p.matcher(line);
                        if (!m.matches()) continue;
                        String key = m.group(1);
                        String value = m.group(2);
                        pack.metas.put(key, value);
                        if (key.equals("name")) {
                            pack.name = value;
                            continue;
                        }
                        if (!key.equals("author")) continue;
                        pack.author = value;
                    }
                    continue;
                }
                catch (Throwable line) {
                    throwable = line;
                    throw line;
                }
                finally {
                    if (s == null) continue;
                    if (throwable != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable line) {
                            throwable.addSuppressed(line);
                        }
                        continue;
                    }
                    s.close();
                    continue;
                }
            }
            if (entry.getName().endsWith(".png") || entry.getName().endsWith(".PNG") || entry.getName().endsWith(".jpg") || entry.getName().endsWith(".JPG")) {
                try {
                    bais = new ByteArrayInputStream(data);
                    throwable = null;
                    try {
                        BufferedImage texture = ImageIO.read(bais);
                        pack.textures.put(entry.getName(), texture);
                    }
                    catch (Throwable texture) {
                        throwable = texture;
                        throw texture;
                    }
                    finally {
                        if (bais == null) continue;
                        if (throwable != null) {
                            try {
                                bais.close();
                            }
                            catch (Throwable texture) {
                                throwable.addSuppressed(texture);
                            }
                            continue;
                        }
                        bais.close();
                    }
                }
                catch (IOException e) {
                    GTS.LOGGER.warn(I18n.func_135052_a((String)"gts.exception.pack_load.texture", (Object[])new Object[]{entry.getName()}));
                }
                continue;
            }
            if (entry.getName().endsWith(".ogg")) {
                pack.sounds.put(entry.getName(), data);
                continue;
            }
            if (entry.getName().endsWith(".json")) {
                try {
                    GTSConfig config = GTSPack.readConfig(data);
                    pack.configs.put(entry.getName(), config);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!entry.getName().endsWith(".mqo")) continue;
            try {
                bais = new ByteArrayInputStream(data);
                throwable = null;
                try {
                    MQO mqo = MQOLoader.load(data).normalize(1.0);
                    GTS.LOGGER.debug((Object)mqo);
                    pack.models.put(entry.getName(), mqo);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (bais == null) continue;
                    if (throwable != null) {
                        try {
                            bais.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    bais.close();
                }
            }
            catch (MQOException | IOException e) {
                GTS.LOGGER.warn(I18n.func_135052_a((String)"gts.exception.pack_load.model", (Object[])new Object[]{entry.getName()}) + " -> " + e.getLocalizedMessage());
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
        return pack;
    }

    public static GTSPack getDummyPack() {
        Throwable throwable;
        InputStream is;
        if (dummyPack != null) {
            return dummyPack;
        }
        GTSPack pack = new GTSPack();
        try {
            pack.models.put(DUMMY, MQOLoader.load(GTS.class.getResourceAsStream("/assets/gts/dummy/dummy.mqo")));
            pack.models.put(DUMMY_TRAFFIC_LIGHT, MQOLoader.load(GTS.class.getResourceAsStream("/assets/gts/dummy/trafficlight.mqo")));
            pack.models.put(DUMMY_TRAFFIC_CONTROLLER, MQOLoader.load(GTS.class.getResourceAsStream("/assets/gts/dummy/trafficcontroller.mqo")));
            pack.models.put(DUMMY_TRAFFIC_POLE, MQOLoader.load(GTS.class.getResourceAsStream("/assets/gts/dummy/trafficpole.mqo")));
            pack.models.put(DUMMY_TRAFFIC_ARM, MQOLoader.load(GTS.class.getResourceAsStream("/assets/gts/dummy/trafficarm.mqo")));
            pack.models.put(DUMMY_TRAFFIC_BUTTON, MQOLoader.load(GTS.class.getResourceAsStream("/assets/gts/dummy/trafficbutton.mqo")));
        }
        catch (MQOException | IOException e) {
            throw new RuntimeException("[ERROR] Cannot load dummy model on GTS!");
        }
        try {
            is = GTS.class.getResourceAsStream("/assets/gts/dummy/dummy.png");
            throwable = null;
            try {
                if (is == null) {
                    throw new IOException();
                }
                pack.textures.put(DUMMY, ImageIO.read(is));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("[ERROR] Cannot load dummy model on GTS!");
        }
        try {
            is = GTS.class.getResourceAsStream("/assets/gts/dummy/trafficlight.png");
            throwable = null;
            try {
                if (is == null) {
                    throw new IOException();
                }
                pack.textures.put(DUMMY_TRAFFIC_LIGHT, ImageIO.read(is));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("[ERROR] Cannot load dummy model on GTS!");
        }
        try {
            is = GTS.class.getResourceAsStream("/assets/gts/dummy/trafficcontroller.png");
            throwable = null;
            try {
                if (is == null) {
                    throw new IOException();
                }
                pack.textures.put(DUMMY_TRAFFIC_CONTROLLER, ImageIO.read(is));
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("[ERROR] Cannot load dummy model on GTS!");
        }
        try {
            is = GTS.class.getResourceAsStream("/assets/gts/dummy/trafficpole.png");
            throwable = null;
            try {
                if (is == null) {
                    throw new IOException();
                }
                pack.textures.put(DUMMY_TRAFFIC_POLE, ImageIO.read(is));
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("[ERROR] Cannot load dummy model on GTS!");
        }
        try {
            is = GTS.class.getResourceAsStream("/assets/gts/dummy/trafficarm.png");
            throwable = null;
            try {
                if (is == null) {
                    throw new IOException();
                }
                pack.textures.put(DUMMY_TRAFFIC_ARM, ImageIO.read(is));
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable11) {
                            throwable.addSuppressed(throwable11);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("[ERROR] Cannot load dummy model on GTS!");
        }
        try {
            is = GTS.class.getResourceAsStream("/assets/gts/dummy/trafficbutton.png");
            throwable = null;
            try {
                if (is == null) {
                    throw new IOException();
                }
                pack.textures.put(DUMMY_TRAFFIC_BUTTON, ImageIO.read(is));
            }
            catch (Throwable throwable12) {
                throwable = throwable12;
                throw throwable12;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable13) {
                            throwable.addSuppressed(throwable13);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("[ERROR] Cannot load dummy model on GTS!");
        }
        try {
            is = GTS.class.getResourceAsStream("/assets/gts/sounds/traffic_button.ogg");
            throwable = null;
            try {
                if (is == null) {
                    throw new IOException();
                }
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    byte[] data = new byte[4096];
                    int readByte = 0;
                    while ((readByte = is.read(data, 0, data.length)) != -1) {
                        baos.write(data, 0, readByte);
                    }
                    pack.sounds.put("traffic_button.ogg", baos.toByteArray());
                }
            }
            catch (Throwable throwable14) {
                throwable = throwable14;
                throw throwable14;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable15) {
                            throwable.addSuppressed(throwable15);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("[ERROR] Cannot load dummy model on GTS!");
        }
        GTS.LOGGER.info(I18n.func_135052_a((String)"gts.message.pack_search.dummy", (Object[])new Object[0]));
        return pack;
    }

    private static byte[] readData(ZipEntry entry, ZipInputStream zis) {
        byte[] data = new byte[(int)entry.getSize()];
        try {
            int read = 0;
            while ((long)read < entry.getSize()) {
                read += zis.read(data, read, (int)(entry.getSize() - (long)read));
            }
        }
        catch (IOException e) {
            GTS.LOGGER.warn(I18n.func_135052_a((String)"gts.exception.pack_load.io", (Object[])new Object[]{entry.getName(), e.getLocalizedMessage()}));
        }
        return data;
    }

    private static GTSConfig readConfig(byte[] data) {
        try {
            return (GTSConfig)GTS.GSON.fromJson(new String(data, StandardCharsets.UTF_8), GTSConfig.class);
        }
        catch (JsonParseException e) {
            GTS.LOGGER.error(I18n.func_135052_a((String)"gts.exception.pack_load.config", (Object[])new Object[]{e.getLocalizedMessage()}));
            return null;
        }
    }

    @Deprecated
    private static GTSConfig readConfigOld(byte[] data) {
        Gson gson = new Gson();
        try {
            GTSTrafficButtonConfig config = (GTSTrafficButtonConfig)gson.fromJson(new String(data, StandardCharsets.UTF_8), GTSTrafficButtonConfig.class);
            if (config.getAudios() == null || config.getAudios().getBase() == null) {
                throw new JsonSyntaxException("");
            }
        }
        catch (JsonSyntaxException e) {
            try {
                GTSTrafficArmConfig config = (GTSTrafficArmConfig)gson.fromJson(new String(data, StandardCharsets.UTF_8), GTSTrafficArmConfig.class);
                if (config.getBaseObjects().isEmpty()) {
                    throw new JsonSyntaxException("");
                }
                return config;
            }
            catch (JsonSyntaxException e2) {
                try {
                    GTSTrafficPoleConfig config = (GTSTrafficPoleConfig)gson.fromJson(new String(data, StandardCharsets.UTF_8), GTSTrafficPoleConfig.class);
                    if (config.getNormalObject() == null) {
                        throw new JsonSyntaxException("");
                    }
                    return config;
                }
                catch (JsonSyntaxException e3) {
                    try {
                        GTSTrafficLightConfig config = (GTSTrafficLightConfig)gson.fromJson(new String(data, StandardCharsets.UTF_8), GTSTrafficLightConfig.class);
                        if (config.getLight() == null) {
                            throw new JsonSyntaxException("");
                        }
                        return config;
                    }
                    catch (JsonSyntaxException e4) {
                        try {
                            return (GTSConfig)gson.fromJson(new String(data, StandardCharsets.UTF_8), GTSTrafficControllerConfig.class);
                        }
                        catch (JsonSyntaxException e5) {
                            GTS.LOGGER.warn("\u30a8\u30e9\u30fc\u3060\uff01");
                        }
                    }
                }
            }
        }
        return null;
    }

    public String toString() {
        return "GTSPack: [name=" + this.name + ", author=" + this.author + ", meta_count=" + this.metas.size() + ", texture_count=" + this.textures.size() + ", sound_count=" + this.sounds.size() + ", model_count=" + this.models.size() + "]";
    }

    public HashMap<String, byte[]> getSounds() {
        return this.sounds;
    }

    public HashMap<String, BufferedImage> getTextures() {
        return this.textures;
    }

    public HashMap<String, MQO> getModels() {
        return this.models;
    }

    public HashMap<String, GTSConfig<GTSConfig.GTSTexture>> getConfigs() {
        return this.configs;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public HashMap<String, String> getMetas() {
        return this.metas;
    }

    public ResourceLocation getOrCreateBindTexture(String name) {
        ResourceLocation r = this.bindTextures.get(name);
        BufferedImage b = this.textures.get(name);
        if (r != null) {
            return r;
        }
        if (b == null) {
            return null;
        }
        r = Minecraft.func_71410_x().func_110434_K().func_110578_a(name, new DynamicTexture(b));
        this.bindTextures.put(name, r);
        return r;
    }

    public MQO getResizingModels(String name, double size) {
        MQO m;
        HashMap<String, MQO> h = this.resizedModels.get(size);
        if (h == null) {
            h = new HashMap();
            this.resizedModels.put(size, h);
        }
        if ((m = h.get(name)) == null) {
            MQO o = this.models.get(name);
            if (o == null) {
                return null;
            }
            o = o.normalize(size);
            h.put(name, o);
            return o;
        }
        return m;
    }

    public HashMap<String, SoundEvent> getSoundEvents() {
        return this.soundEvents;
    }
}

