/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.core.mqo;

import com.gfactory.core.mqo.MQOFace;
import com.gfactory.core.mqo.MQOVBOData;
import com.gfactory.core.mqo.MQOVertex;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;

public final class MQOObject {
    private ArrayList<MQOFace> faces = new ArrayList();
    private ArrayList<MQOVertex> vertexs = new ArrayList();
    private final ArrayList<MQOVertex> normals = new ArrayList();
    private double smoothing = Math.toRadians(59.5);
    private String name;
    private MQOVBOData vboData;
    private double[][] minMax;

    public MQOObject(String name) {
        this.name = name;
    }

    public ArrayList<MQOFace> getFaces() {
        return this.faces;
    }

    public void setFaces(ArrayList<MQOFace> faces) {
        this.faces = faces;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList<MQOVertex> getVertexs() {
        return this.vertexs;
    }

    public void setVertexs(ArrayList<MQOVertex> vertexs) {
        this.vertexs = vertexs;
    }

    public String toString() {
        return "MQOObject(" + this.name + ")[V=" + this.vertexs.size() + ", F=" + this.faces.size() + "]";
    }

    public String toDetailString() {
        return "MQOObject(" + this.name + ")[V=" + this.vertexs + ", F=" + this.faces + "]";
    }

    private void buildVBO(boolean useNormal) {
        ArrayList<MQOFace> triangles = new ArrayList<MQOFace>();
        for (MQOFace face : this.faces) {
            triangles.addAll(Arrays.asList(face.splitTriangleFace()));
        }
        List<MQOVertex> normals = this.calcFaceVertexNormals(triangles);
        FloatBuffer vs = BufferUtils.createFloatBuffer((int)(triangles.size() * 3 * 8));
        IntBuffer indices = BufferUtils.createIntBuffer((int)(triangles.size() * 3));
        int vertexIndex = 0;
        for (MQOFace face : triangles) {
            int[] vIds = face.getVertexId();
            double[][] uvs = face.getUv();
            for (int i = 0; i < 3; ++i) {
                MQOVertex v = this.vertexs.get(vIds[i]);
                MQOVertex n = normals.get(vertexIndex);
                double[] uv = uvs[i];
                vs.put((float)v.getX());
                vs.put((float)v.getY());
                vs.put((float)v.getZ());
                vs.put((float)uv[0]);
                vs.put((float)uv[1]);
                if (useNormal) {
                    vs.put((float)n.getX());
                    vs.put((float)n.getY());
                    vs.put((float)n.getZ());
                } else {
                    double shadowColor = this.getShadowColor(n);
                    vs.put((float)shadowColor);
                    vs.put((float)shadowColor);
                    vs.put((float)shadowColor);
                }
                indices.put(vertexIndex++);
            }
        }
        vs.flip();
        indices.flip();
        this.vboData = new MQOVBOData(indices, vs);
        this.vboData.setUseNormal(useNormal);
        this.vboData.loadGPU();
    }

    public void buildVBO() {
        this.buildVBO(true);
    }

    private double getShadowColor(MQOVertex normal) {
        Vec3d verticalVec = new Vec3d(0.0, -1.0, 0.0);
        Vec3d faceVec = new Vec3d(normal.getX(), normal.getY(), normal.getZ()).func_72432_b();
        double dot = faceVec.func_72430_b(verticalVec);
        dot = (dot + 1.0) / 2.0;
        return dot;
    }

    public void draw() {
        if (this.vboData == null) {
            this.buildVBO();
            return;
        }
        if (!this.vboData.isGPULoaded()) {
            this.vboData.loadGPU();
            return;
        }
        int prevVBO = GL11.glGetInteger((int)34964);
        GL11.glEnable((int)2977);
        GL13.glActiveTexture((int)33984);
        GL15.glBindBuffer((int)34962, (int)this.vboData.getVid());
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        if (this.vboData.isUseNormal()) {
            GL20.glEnableVertexAttribArray((int)2);
        } else {
            GL20.glEnableVertexAttribArray((int)3);
        }
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)32, (long)0L);
        GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)32, (long)12L);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)32, (long)12L);
        GlStateManager.func_187410_q((int)32888);
        if (this.vboData.isUseNormal()) {
            GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)32, (long)20L);
        } else {
            GL20.glVertexAttribPointer((int)3, (int)3, (int)5126, (boolean)false, (int)32, (long)20L);
        }
        GL11.glDrawArrays((int)4, (int)0, (int)(this.vboData.getVertexVBO().capacity() / 8));
        GL20.glDisableVertexAttribArray((int)0);
        GL20.glDisableVertexAttribArray((int)1);
        if (this.vboData.isUseNormal()) {
            GL20.glDisableVertexAttribArray((int)2);
        } else {
            GL20.glDisableVertexAttribArray((int)3);
        }
        GlStateManager.func_187429_p((int)32888);
        GL15.glBindBuffer((int)34962, (int)prevVBO);
    }

    private void calcNormal() {
        int i;
        ArrayList<MQOFace> triangleFaces = new ArrayList<MQOFace>();
        for (MQOFace face : this.faces) {
            triangleFaces.addAll(Arrays.asList(face.splitTriangleFace()));
        }
        ArrayList<MQOVertex> faceNormals = new ArrayList<MQOVertex>();
        HashMap vertexToFaceMap = new HashMap();
        for (i = 0; i < this.vertexs.size(); ++i) {
            vertexToFaceMap.put(i, new ArrayList());
        }
        for (i = 0; i < triangleFaces.size(); ++i) {
            MQOFace f = (MQOFace)triangleFaces.get(i);
            MQOVertex v0 = this.vertexs.get(f.getVertexId()[0]);
            MQOVertex v1 = this.vertexs.get(f.getVertexId()[1]);
            MQOVertex v2 = this.vertexs.get(f.getVertexId()[2]);
            double[] b1 = new double[]{v1.getX() - v0.getX(), v1.getY() - v0.getY(), v1.getZ() - v0.getZ()};
            double[] b2 = new double[]{v2.getX() - v0.getX(), v2.getY() - v0.getY(), v2.getZ() - v0.getZ()};
            double[] cross = new double[]{b1[1] * b2[2] - b1[2] * b2[1], b1[2] * b2[0] - b1[0] * b2[2], b1[0] * b2[1] - b1[1] * b2[0]};
            double length = Math.sqrt(Math.pow(cross[0], 2.0) + Math.pow(cross[1], 2.0) + Math.pow(cross[2], 2.0));
            MQOVertex faceNormal = new MQOVertex(cross[0] / length, cross[1] / length, cross[2] / length);
            faceNormals.add(faceNormal);
            for (int vid : f.getVertexId()) {
                ((List)vertexToFaceMap.get(vid)).add(i);
            }
        }
        double cos = Math.cos(this.smoothing);
        for (int i2 = 0; i2 < this.vertexs.size(); ++i2) {
            double len;
            List relatedFaces = (List)vertexToFaceMap.get(i2);
            MQOVertex normalSum = new MQOVertex(0.0, 0.0, 0.0);
            Iterator b1 = relatedFaces.iterator();
            if (b1.hasNext()) {
                int fi = (Integer)b1.next();
                MQOVertex baseNormal = (MQOVertex)faceNormals.get(fi);
                Iterator iterator = relatedFaces.iterator();
                while (iterator.hasNext()) {
                    int fj = (Integer)iterator.next();
                    MQOVertex compNormal = (MQOVertex)faceNormals.get(fj);
                    double dot = baseNormal.getX() * compNormal.getX() + baseNormal.getY() * compNormal.getY() + baseNormal.getZ() * compNormal.getZ();
                    if (!(dot >= cos)) continue;
                    normalSum.setX(normalSum.getX() + compNormal.getX());
                    normalSum.setY(normalSum.getY() + compNormal.getY());
                    normalSum.setZ(normalSum.getZ() + compNormal.getZ());
                }
            }
            if ((len = Math.sqrt(normalSum.getX() * normalSum.getX() + normalSum.getY() * normalSum.getY() + normalSum.getZ() * normalSum.getZ())) > 0.0) {
                this.normals.add(new MQOVertex(normalSum.getX() / len, normalSum.getY() / len, normalSum.getZ() / len));
                continue;
            }
            this.normals.add(new MQOVertex(0.0, 1.0, 0.0));
        }
    }

    public List<MQOVertex> calcFaceVertexNormals(List<MQOFace> triangleFaces) {
        int i;
        ArrayList<MQOVertex> faceNormals = new ArrayList<MQOVertex>();
        HashMap vertexToFaceMap = new HashMap();
        for (i = 0; i < this.vertexs.size(); ++i) {
            vertexToFaceMap.put(i, new ArrayList());
        }
        for (i = 0; i < triangleFaces.size(); ++i) {
            MQOFace f = triangleFaces.get(i);
            int[] vId = f.getVertexId();
            MQOVertex v0 = this.vertexs.get(vId[0]);
            MQOVertex v1 = this.vertexs.get(vId[1]);
            MQOVertex v2 = this.vertexs.get(vId[2]);
            double[] b1 = new double[]{v1.getX() - v0.getX(), v1.getY() - v0.getY(), v1.getZ() - v0.getZ()};
            double[] b2 = new double[]{v2.getX() - v0.getX(), v2.getY() - v0.getY(), v2.getZ() - v0.getZ()};
            double[] cross = new double[]{b1[1] * b2[2] - b1[2] * b2[1], b1[2] * b2[0] - b1[0] * b2[2], b1[0] * b2[1] - b1[1] * b2[0]};
            double length = Math.sqrt(cross[0] * cross[0] + cross[1] * cross[1] + cross[2] * cross[2]);
            MQOVertex fn = new MQOVertex(cross[0] / length, cross[1] / length, cross[2] / length);
            faceNormals.add(fn);
            for (int vid : vId) {
                ((List)vertexToFaceMap.get(vid)).add(i);
            }
        }
        double cos = Math.cos(this.smoothing);
        ArrayList<MQOVertex> vertexNormals = new ArrayList<MQOVertex>();
        for (int i2 = 0; i2 < triangleFaces.size(); ++i2) {
            MQOFace face = triangleFaces.get(i2);
            for (int j = 0; j < 3; ++j) {
                int vertexId = face.getVertexId()[j];
                MQOVertex normalSum = new MQOVertex(0.0, 0.0, 0.0);
                MQOVertex currentNormal = (MQOVertex)faceNormals.get(i2);
                Iterator length = ((List)vertexToFaceMap.get(vertexId)).iterator();
                while (length.hasNext()) {
                    int fi = (Integer)length.next();
                    MQOVertex otherNormal = (MQOVertex)faceNormals.get(fi);
                    double dot = currentNormal.getX() * otherNormal.getX() + currentNormal.getY() * otherNormal.getY() + currentNormal.getZ() * otherNormal.getZ();
                    if (!(dot >= cos)) continue;
                    normalSum.setX(normalSum.getX() + otherNormal.getX());
                    normalSum.setY(normalSum.getY() + otherNormal.getY());
                    normalSum.setZ(normalSum.getZ() + otherNormal.getZ());
                }
                double len = Math.sqrt(normalSum.getX() * normalSum.getX() + normalSum.getY() * normalSum.getY() + normalSum.getZ() * normalSum.getZ());
                if (len > 0.0) {
                    vertexNormals.add(new MQOVertex(normalSum.getX() / len, normalSum.getY() / len, normalSum.getZ() / len));
                    continue;
                }
                vertexNormals.add(new MQOVertex(0.0, 1.0, 0.0));
            }
        }
        return vertexNormals;
    }

    public ArrayList<MQOVertex> getNormals() {
        if (this.normals.isEmpty()) {
            this.calcNormal();
        }
        return this.normals;
    }

    public double getSmoothing() {
        return this.smoothing;
    }

    public void setSmoothing(double smoothing) {
        this.smoothing = smoothing;
    }

    public double[][] getAxisMinMax() {
        if (this.minMax == null) {
            return this.calcAxisMinMax();
        }
        return this.minMax;
    }

    public MQOVertex[] getBoundingBox() {
        double[][] minMax = this.getAxisMinMax();
        return new MQOVertex[]{new MQOVertex(minMax[0][0], minMax[1][0], minMax[2][0]), new MQOVertex(minMax[0][1], minMax[1][1], minMax[2][1])};
    }

    private double[][] calcAxisMinMax() {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        for (MQOVertex v : this.vertexs) {
            minX = Math.min(minX, v.getX());
            maxX = Math.max(maxX, v.getX());
            minY = Math.min(minY, v.getY());
            maxY = Math.max(maxY, v.getY());
            minZ = Math.min(minZ, v.getZ());
            maxZ = Math.max(maxZ, v.getZ());
        }
        this.minMax = new double[][]{{minX, maxX}, {minY, maxY}, {minZ, maxZ}};
        return new double[][]{{minX, maxX}, {minY, maxY}, {minZ, maxZ}};
    }
}

