/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.core.mqo;

import com.gfactory.core.mqo.MQO;
import com.gfactory.core.mqo.MQOException;
import com.gfactory.core.mqo.MQOFace;
import com.gfactory.core.mqo.MQOObject;
import com.gfactory.core.mqo.MQOVertex;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MQOLoader {
    private MQOLoader() {
    }

    public static MQO load(InputStream is, boolean createThumbnail) throws IOException, MQOException {
        try (Scanner s = new Scanner(is);){
            MQO mQO = MQOLoader.parse(s, createThumbnail);
            return mQO;
        }
    }

    public static MQO load(InputStream is) throws IOException, MQOException {
        return MQOLoader.load(is, false);
    }

    public static MQO load(byte[] data) throws IOException, MQOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
            MQO mQO = MQOLoader.load(bais);
            return mQO;
        }
    }

    private static MQO parse(Scanner s, boolean createThumbnail) throws MQOException, IOException {
        Pattern chunkPattern = Pattern.compile("^(.+?) (.+ ?)*\\{$");
        Pattern facePattern = Pattern.compile("^(\\d+) V\\(([0123456789 ]+)\\) M\\(([0123456789 ]+)\\) UV\\(([0123456789.e+\\- ]+)\\)$");
        ArrayDeque<Chunk> chunkQueue = new ArrayDeque<Chunk>();
        MQOObject object = null;
        Object rawThumbnail = new int[][]{};
        StringBuilder rawThumbnailString = new StringBuilder();
        MQO mqo = new MQO();
        while (s.hasNextLine()) {
            String line = s.nextLine().trim().replace("\t", "");
            if (line.startsWith("}")) {
                Chunk c = (Chunk)((Object)chunkQueue.pollLast());
                if (!Chunk.Object.equals((Object)c)) continue;
                mqo.getObjects().add(object);
                object = null;
                continue;
            }
            if (line.endsWith("{")) {
                Chunk c;
                Matcher m = chunkPattern.matcher(line.trim());
                if (!m.matches() || (c = Chunk.toChunk(m.group(1))) == null || c.equals((Object)Chunk.Thumbnail) && !createThumbnail) continue;
                chunkQueue.offer(c);
                if (c.equals((Object)Chunk.Object)) {
                    object = new MQOObject(m.group(2).replace("\"", "").trim());
                    continue;
                }
                if (!c.equals((Object)Chunk.Thumbnail)) continue;
                String[] meta = m.group(2).split(" ");
                rawThumbnail = new int[Integer.parseInt(meta[0])][Integer.parseInt(meta[1])];
                continue;
            }
            if (chunkQueue.peekLast() == null) continue;
            switch ((Chunk)((Object)chunkQueue.peekLast())) {
                case Object: {
                    if (!line.startsWith("facet")) break;
                    String smoothing = line.split(" ")[1];
                    try {
                        object.setSmoothing(Math.toRadians(Double.parseDouble(smoothing)));
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Warning: could not read smoothing");
                    }
                    break;
                }
                case Vertex: {
                    String[] v = line.trim().split(" ");
                    if (v.length != 3) {
                        throw new MQOException("Vertex has over 4 position.");
                    }
                    MQOVertex vertex = new MQOVertex(Double.parseDouble(v[0]), Double.parseDouble(v[1]), Double.parseDouble(v[2]));
                    if (object == null) {
                        throw new MQOException("Vertex is not included in Object Chunk.");
                    }
                    object.getVertexs().add(vertex);
                    break;
                }
                case Face: {
                    if (object == null) {
                        throw new MQOException("Face is not included in Object Chunk.");
                    }
                    Matcher fm = facePattern.matcher(line);
                    if (!fm.matches()) break;
                    String[] vs = fm.group(2).split(" ");
                    int[] vs2 = new int[vs.length];
                    for (int i = 0; i < vs.length; ++i) {
                        vs2[i] = Integer.parseInt(vs[i]);
                    }
                    String[] uvs = fm.group(4).split(" ");
                    double[][] uvs2 = new double[uvs.length][2];
                    for (int i = 0; i < vs.length; ++i) {
                        uvs2[i] = new double[]{Double.parseDouble(uvs[i * 2]), Double.parseDouble(uvs[i * 2 + 1])};
                    }
                    int material = Integer.parseInt(fm.group(3));
                    int vLength = Integer.parseInt(fm.group(1));
                    if (vs.length != vLength || uvs.length != vLength * 2) {
                        throw new MQOException("Face has wrong vertexs or uvs");
                    }
                    MQOFace face = new MQOFace(material, uvs2, vs2, vs.length);
                    object.getFaces().add(face);
                    break;
                }
                case Material: {
                    break;
                }
                case Thumbnail: {
                    rawThumbnailString.append(line);
                    break;
                }
            }
        }
        if (createThumbnail) {
            int w = 0;
            for (int i = 0; i < rawThumbnailString.length(); i += 6) {
                String rgb = rawThumbnailString.substring(i, i + 6);
                rawThumbnail[Math.min((int)(i / 6 % rawThumbnail[0].length), (int)(rawThumbnail[0].length - 1))][w / 128] = Integer.parseInt(rgb, 16);
                ++w;
            }
            mqo.createThumbnailImage((int[][])rawThumbnail);
        }
        chunkQueue.clear();
        return mqo;
    }

    private static enum Chunk {
        Object("Object"),
        Vertex("vertex"),
        Face("face"),
        Material("Material"),
        Thumbnail("Thumbnail");

        final String line;

        private Chunk(String line) {
            this.line = line;
        }

        public String getName() {
            return this.line;
        }

        public static Chunk toChunk(String name) {
            for (Chunk c : Chunk.values()) {
                if (!c.line.equals(name)) continue;
                return c;
            }
            return null;
        }
    }
}

