/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.minecraft.tileentity;

import com.gfactory.gts.minecraft.GTS;
import com.gfactory.gts.minecraft.network.packet.GTSPacketTileEntity;
import com.gfactory.gts.minecraft.sound.GTSSoundTrafficButtonBase;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntity;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntityTrafficController;
import com.gfactory.gts.minecraft.tileentity.IGTSAttachable;
import com.gfactory.gts.pack.GTSPack;
import com.gfactory.gts.pack.config.GTSTrafficButtonConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class GTSTileEntityTrafficButton
extends GTSTileEntity<GTSTrafficButtonConfig>
implements IGTSAttachable<GTSTileEntityTrafficController>,
ITickable {
    private BlockPos attachedTrafficController;
    private boolean detected;
    private int maxWaitTick = 0;
    private int nowTick = 0;

    public GTSTileEntityTrafficButton() {
        this.setDummy();
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public void setDummy() {
        GTSPack p = GTS.LOADER.getDummy();
        if (p == null) {
            throw new RuntimeException("Dummy Model cannot be loaded.");
        }
        this.pack = p;
        GTSTrafficButtonConfig config = new GTSTrafficButtonConfig();
        config.setDummy();
        this.setConfig(config);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("gts_attached_traffic_controller")) {
            this.attachedTrafficController = BlockPos.func_177969_a((long)compound.func_74763_f("gts_attached_traffic_controller"));
        }
        this.detected = compound.func_74767_n("gts_detected");
        this.maxWaitTick = compound.func_74762_e("gts_maxWaitTick");
        this.nowTick = compound.func_74762_e("gts_nowTick");
    }

    @Override
    public NBTTagCompound writeDataToNBT(NBTTagCompound compound) {
        compound.func_74757_a("gts_detected", this.detected);
        compound.func_74768_a("gts_maxWaitTick", this.maxWaitTick);
        compound.func_74768_a("gts_nowTick", this.nowTick);
        if (this.attachedTrafficController != null) {
            compound.func_74772_a("gts_attached_traffic_controller", this.attachedTrafficController.func_177986_g());
        }
        return compound;
    }

    @Override
    public void attach(GTSTileEntityTrafficController te) {
        this.attachedTrafficController = te.func_174877_v();
        if (this.field_145850_b.field_72995_K) {
            GTS.NETWORK.sendToServer(new GTSPacketTileEntity<GTSTileEntityTrafficButton>(this.func_189515_b(new NBTTagCompound()), this.field_174879_c, GTSTileEntityTrafficButton.class));
        }
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 15);
        }
    }

    @Override
    public void deattach(GTSTileEntityTrafficController te) {
        this.attachedTrafficController = null;
        if (this.field_145850_b.field_72995_K) {
            GTS.NETWORK.sendToServer(new GTSPacketTileEntity<GTSTileEntityTrafficButton>(this.func_189515_b(new NBTTagCompound()), this.field_174879_c, GTSTileEntityTrafficButton.class));
        }
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 15);
        }
    }

    @Override
    public void reset() {
        this.attachedTrafficController = null;
        if (this.field_145850_b.field_72995_K) {
            GTS.NETWORK.sendToServer(new GTSPacketTileEntity<GTSTileEntityTrafficButton>(this.func_189515_b(new NBTTagCompound()), this.field_174879_c, GTSTileEntityTrafficButton.class));
        }
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 15);
        }
    }

    public BlockPos getAttachedTrafficController() {
        return this.attachedTrafficController;
    }

    public void setAttachedTrafficController(BlockPos attachedTrafficController) {
        this.attachedTrafficController = attachedTrafficController;
        if (this.field_145850_b.field_72995_K) {
            GTS.NETWORK.sendToServer(new GTSPacketTileEntity<GTSTileEntityTrafficButton>(this.func_189515_b(new NBTTagCompound()), this.field_174879_c, GTSTileEntityTrafficButton.class));
        }
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 15);
        }
    }

    public boolean isDetected() {
        return this.detected;
    }

    public void setDetected(boolean detected) {
        if (detected && !this.detected) {
            this.nowTick = 0;
        }
        this.detected = detected;
        this.sendDetected();
        if (this.field_145850_b.field_72995_K) {
            GTS.NETWORK.sendToServer(new GTSPacketTileEntity<GTSTileEntityTrafficButton>(this.func_189515_b(new NBTTagCompound()), this.field_174879_c, GTSTileEntityTrafficButton.class));
        }
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 15);
        }
    }

    public int getMaxWaitTick() {
        return this.maxWaitTick;
    }

    public void setMaxWaitTick(int maxWaitTick) {
        this.maxWaitTick = maxWaitTick;
        if (this.field_145850_b.field_72995_K) {
            GTS.NETWORK.sendToServer(new GTSPacketTileEntity<GTSTileEntityTrafficButton>(this.func_189515_b(new NBTTagCompound()), this.field_174879_c, GTSTileEntityTrafficButton.class));
        }
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 15);
        }
    }

    public void func_73660_a() {
        if (this.maxWaitTick > 0 && this.nowTick >= this.maxWaitTick) {
            this.nowTick = 0;
            this.detected = false;
        } else {
            this.nowTick = this.nowTick >= 0x7FFFFFFA ? 0 : ++this.nowTick;
        }
        if (this.field_145850_b.field_72995_K && this.getConfig() != null && ((GTSTrafficButtonConfig)this.getConfig()).getBaseSoundTick() != 0 && this.field_145850_b.func_82737_E() % (long)((GTSTrafficButtonConfig)this.getConfig()).getBaseSoundTick() == 0L) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new GTSSoundTrafficButtonBase(this));
        }
    }

    private void sendDetected() {
        if (this.attachedTrafficController == null) {
            return;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.attachedTrafficController);
        if (!(te instanceof GTSTileEntityTrafficController)) {
            return;
        }
        GTSTileEntityTrafficController controller = (GTSTileEntityTrafficController)te;
        controller.setDetected(true);
    }
}

