/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.minecraft.tileentity;

import com.gfactory.core.helper.GNBTHelper;
import com.gfactory.core.mqo.MQOFace;
import com.gfactory.core.mqo.MQOObject;
import com.gfactory.core.mqo.MQOVertex;
import com.gfactory.gts.common.GTSSignTextureManager;
import com.gfactory.gts.minecraft.GTS;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntity;
import com.gfactory.gts.pack.config.GTSTrafficSignConfig;
import java.util.Arrays;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class GTSTileEntityTrafficSign
extends GTSTileEntity {
    private double width = 1.6f;
    private double height = 0.8f;
    private double depth = 0.05f;
    private ResourceLocation texture;
    private GTSSignTextureManager.GTS114Sign info;
    private transient MQOObject object;

    public GTSTileEntityTrafficSign() {
        this.setDummy();
    }

    @Override
    public String getName() {
        return I18n.func_135052_a((String)"tile.traffic_sign.name", (Object[])new Object[0]);
    }

    @Override
    public void setDummy() {
        this.pack = GTS.LOADER.getDummy();
        this.config = new GTSTrafficSignConfig();
        this.config.setDummy();
        this.texture = null;
        this.info = new GTSSignTextureManager.GTS114Sign();
        this.info.japanese = "\u30c0\u30df\u30fc";
        this.info.english = "DUMMY";
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        this.width = GNBTHelper.getDoubleWithValue(compound, "gts_sign_width", this.width);
        this.height = GNBTHelper.getDoubleWithValue(compound, "gts_sign_height", this.height);
        this.depth = GNBTHelper.getDoubleWithValue(compound, "gts_sign_depth", this.depth);
        if (compound.func_74764_b("gts_sign_texture")) {
            this.texture = new ResourceLocation(compound.func_74779_i("gts_sign_texture"));
            this.info = null;
        } else {
            this.texture = null;
            this.info = new GTSSignTextureManager.GTS114Sign();
            this.info.readFromNBT(compound.func_74775_l("gts_sign_info"));
        }
    }

    @Override
    public NBTTagCompound writeDataToNBT(NBTTagCompound compound) {
        compound.func_74780_a("gts_sign_width", this.width);
        compound.func_74780_a("gts_sign_height", this.height);
        compound.func_74780_a("gts_sign_depth", this.depth);
        if (this.texture != null && !this.is114Sign()) {
            compound.func_74778_a("gts_sign_texture", this.texture.toString());
        }
        if (this.is114Sign()) {
            compound.func_74782_a("gts_sign_info", (NBTBase)this.info.writeToNBT());
        }
        return compound;
    }

    private void buildObject() {
        double width = this.width / 2.0;
        double height = this.height / 2.0;
        double depth = this.depth / 2.0;
        MQOVertex v1 = new MQOVertex(-width, height, depth);
        MQOVertex v2 = new MQOVertex(-width, -height, depth);
        MQOVertex v3 = new MQOVertex(width, height, depth);
        MQOVertex v4 = new MQOVertex(width, -height, depth);
        MQOVertex v5 = new MQOVertex(width, height, -depth);
        MQOVertex v6 = new MQOVertex(width, -height, -depth);
        MQOVertex v7 = new MQOVertex(-width, height, -depth);
        MQOVertex v8 = new MQOVertex(-width, -height, -depth);
        MQOFace f1 = new MQOFace(0, new double[][]{{0.0, 0.0}, {0.9, 0.0}, {0.9, 0.45}, {0.0, 0.45}}, new int[]{0, 2, 3, 1}, 4);
        MQOFace f2 = new MQOFace(0, new double[][]{{0.0, 0.45}, {0.9, 0.45}, {0.9, 0.9}, {0.0, 0.9}}, new int[]{2, 4, 5, 3}, 4);
        MQOFace f3 = new MQOFace(0, new double[][]{{0.9, 0.9}, {0.9, 1.0}, {1.0, 1.0}, {1.0, 0.9}}, new int[]{4, 6, 7, 5}, 4);
        MQOFace f4 = new MQOFace(0, new double[][]{{0.9, 0.9}, {0.9, 1.0}, {1.0, 1.0}, {1.0, 0.9}}, new int[]{6, 0, 1, 7}, 4);
        MQOFace f5 = new MQOFace(0, new double[][]{{0.9, 0.9}, {0.9, 1.0}, {1.0, 1.0}, {1.0, 0.9}}, new int[]{6, 4, 2, 0}, 4);
        MQOFace f6 = new MQOFace(0, new double[][]{{0.9, 0.9}, {0.9, 1.0}, {1.0, 1.0}, {1.0, 0.9}}, new int[]{1, 3, 5, 7}, 4);
        MQOObject o = new MQOObject("body");
        o.getVertexs().addAll(Arrays.asList(v1, v2, v3, v4, v5, v6, v7, v8));
        o.getFaces().addAll(Arrays.asList(f1, f2, f3, f4, f5, f6));
        o.buildVBO();
        this.object = o;
    }

    public MQOObject getObject() {
        if (this.object == null) {
            this.buildObject();
        }
        return this.object;
    }

    public double getDepth() {
        return this.depth;
    }

    public void setDepth(double depth) {
        this.depth = depth;
        this.buildObject();
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
        this.buildObject();
    }

    public void setObject(MQOObject object) {
        this.object = object;
    }

    public ResourceLocation getTexture() {
        if ((this.texture == null || this.texture.equals((Object)GTSSignTextureManager.PLACE_HOLDER)) && this.is114Sign()) {
            this.texture = GTS.SIGN_MANAGER.getResourceLocation(this.info);
        }
        return this.texture;
    }

    public void setTexture(ResourceLocation texture) {
        this.texture = texture;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
        this.buildObject();
    }

    public GTSSignTextureManager.GTS114Sign getInfo() {
        return this.info;
    }

    public void setInfo(GTSSignTextureManager.GTS114Sign info) {
        this.info = info;
    }

    public boolean is114Sign() {
        return this.info != null;
    }

    public String toString() {
        return "GTSTileEntityTrafficSign{depth=" + this.depth + ", width=" + this.width + ", height=" + this.height + ", texture=" + this.texture + ", info=" + this.info + ", object=" + this.object + ", angle=" + this.angle + ", config=" + this.config + ", modelMinMax=" + Arrays.toString((Object[])this.modelMinMax) + ", pack=" + this.pack + ", posX=" + this.posX + ", posY=" + this.posY + ", posZ=" + this.posZ + ", blockType=" + this.field_145854_h + ", pos=" + this.field_174879_c + ", tileEntityInvalid=" + this.field_145846_f + ", world=" + this.field_145850_b + "} " + super.toString();
    }
}

