/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.minecraft.item;

import com.gfactory.gts.common.capability.GTSCapabilities;
import com.gfactory.gts.common.capability.IGTSSelection;
import com.gfactory.gts.minecraft.GTS;
import com.gfactory.gts.minecraft.gui.GTSGuiTrafficArm;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntityTrafficArm;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntityTrafficPole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class GTSItemTrafficArm
extends Item {
    public GTSItemTrafficArm() {
        this.setRegistryName("gts", "traffic_arm");
        this.func_77655_b("gts.traffic_arm");
        this.func_77637_a(GTS.TAB);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        NBTTagCompound compound = playerIn.func_184586_b(handIn).func_77978_p();
        GTSTileEntityTrafficArm te = new GTSTileEntityTrafficArm(null);
        if (compound != null) {
            te.func_145839_a(compound);
        }
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GTSGuiTrafficArm(te, playerIn.func_184586_b(handIn), playerIn.field_71071_by.field_70461_c));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IGTSSelection selection;
        if (!worldIn.field_72995_K) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        NBTTagCompound compound = stack.func_77978_p();
        GTSTileEntityTrafficArm arm = new GTSTileEntityTrafficArm(null);
        if (compound != null) {
            arm.func_145839_a(compound);
        }
        if ((selection = (IGTSSelection)player.getCapability(GTSCapabilities.SELECTION_CAP, null)) == null) {
            return EnumActionResult.PASS;
        }
        BlockPos selectedPos = selection.getSelectedTileEntity();
        TileEntity end = worldIn.func_175625_s(pos);
        if (end instanceof GTSTileEntityTrafficPole && selectedPos == null) {
            selection.setSelectedTileEntity(pos);
            player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"gts.message.chat.selected", (Object[])new Object[]{pos})));
        } else if (end instanceof GTSTileEntityTrafficPole && selectedPos.equals((Object)pos)) {
            selection.clearSelection();
            player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"gts.message.chat.deselected", (Object[])new Object[]{pos})));
        } else if (selectedPos != null) {
            TileEntity selectedTileEntity = worldIn.func_175625_s(selectedPos);
            if (!(selectedTileEntity instanceof GTSTileEntityTrafficPole)) {
                return EnumActionResult.PASS;
            }
            GTSTileEntityTrafficPole pole = (GTSTileEntityTrafficPole)selectedTileEntity;
            arm.func_174878_a(pos);
            if (pole.getJointArms().contains((Object)arm)) {
                pole.deattach(arm);
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"gts.message.chat.deattached", (Object[])new Object[]{pos, selectedPos})));
                selection.clearSelection();
            } else {
                pole.attach(arm);
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"gts.message.chat.attached", (Object[])new Object[]{pos, selectedPos})));
                selection.clearSelection();
            }
        }
        return EnumActionResult.SUCCESS;
    }
}

