/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.minecraft.gui.widget;

import com.gfactory.gts.minecraft.gui.widget.GTSWidget;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntity;
import com.gfactory.gts.pack.config.GTSConfig;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.math.MathHelper;

public class GTSGuiScrollList
extends GTSWidget<GTSTileEntity> {
    private final TreeMap<String, ? extends GTSConfig> choices;
    private String selectedChoice = "";
    private int maxHeight;
    public static final int BAR_WIDTH = 5;
    private int scrollOffset;

    public GTSGuiScrollList(GTSTileEntity te, int width, int height, int x, int y, TreeMap<String, ? extends GTSConfig> choices) {
        super(te, width, height, x, y);
        this.choices = choices;
        this.maxHeight = Minecraft.func_71410_x().field_71466_p.field_78288_b * choices.size();
    }

    public GTSConfig getSelectedChoice() {
        return this.choices.get(this.selectedChoice);
    }

    @Override
    public void draw() {
        Gui.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)0x20FFFFFF);
        int start = this.scrollOffset;
        int end = this.scrollOffset + this.height;
        int absoluteY = 0;
        for (Map.Entry<String, ? extends GTSConfig> entry : this.choices.entrySet()) {
            if (absoluteY >= start) {
                if (Objects.equals(this.selectedChoice, entry.getKey())) {
                    Gui.func_73734_a((int)this.x, (int)(this.y + absoluteY - start), (int)(this.x + this.width), (int)(this.y + absoluteY - start + Minecraft.func_71410_x().field_71466_p.field_78288_b), (int)-2147418368);
                }
                Minecraft.func_71410_x().field_71466_p.func_78276_b(entry.getKey(), this.x + 2, this.y + absoluteY - start, 0xFFFFFF);
            }
            absoluteY += Minecraft.func_71410_x().field_71466_p.field_78288_b;
        }
        if (this.height >= this.maxHeight) {
            return;
        }
        int barLength = (int)((float)this.height / (float)this.maxHeight * (float)this.height);
        int barTop = (int)((float)this.scrollOffset / (float)this.maxHeight * (float)this.height);
        Gui.func_73734_a((int)(this.x + this.width - 5), (int)(this.y + barTop), (int)(this.x + this.width), (int)(this.y + barTop + barLength), (int)-16711936);
    }

    @Override
    public void handleMouseInput(int mouseX, int mouseY, float mouseWheel, int mouseButton) throws IOException {
        boolean inBounds;
        boolean bl = inBounds = mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height;
        if (!inBounds) {
            return;
        }
        this.scrollOffset = (int)((float)this.scrollOffset - Math.signum(mouseWheel) * 5.0f * (float)Minecraft.func_71410_x().field_71466_p.field_78288_b);
        this.scrollOffset = MathHelper.func_76125_a((int)this.scrollOffset, (int)0, (int)Math.max(0, this.maxHeight - this.height));
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean inBounds;
        boolean bl = inBounds = mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height;
        if (!inBounds) {
            return;
        }
        int start = this.scrollOffset;
        int absoluteY = 0;
        for (Map.Entry<String, ? extends GTSConfig> entry : this.choices.entrySet()) {
            if (absoluteY < start) {
                absoluteY += Minecraft.func_71410_x().field_71466_p.field_78288_b;
                continue;
            }
            if (this.y + absoluteY - start <= mouseY && this.y + absoluteY - start + Minecraft.func_71410_x().field_71466_p.field_78288_b >= mouseY) {
                if (entry.getValue() == null) continue;
                this.selectedChoice = entry.getKey();
                break;
            }
            absoluteY += Minecraft.func_71410_x().field_71466_p.field_78288_b;
        }
    }
}

